<?php

/**
 * @file
 * Plugin Name: Informea data
 * Description: Import data from informea
 * Version: 1.0
 * License: GPL2
 */

add_action('rest_api_init', function () {
  register_rest_route('informea/v1', '/data', [
    'methods'  => 'GET',
    'callback' => 'get_default_index',
    'permission_callback' => '__return_true',
  ]);
  register_rest_route('informea/v1', '/field-data', [
    'methods'  => 'GET',
    'callback' => 'get_field_data',
    'permission_callback' => '__return_true',
  ]);
});

/**
 * Callback function for the custom endpoint.
 *
 * @param WP_REST_Request $request
 *   The REST request.
 *
 * @return WP_REST_Response
 */
function get_default_index(WP_REST_Request $request) {
  $baseURL = INFORMEA_SEARCH_API_URL . '/en/jsonapi/index/default_index';
  $query = $request->get_param('query');
  parse_str($query, $params);
  $encodedQuery = http_build_query($params, '', '&', PHP_QUERY_RFC3986);
  $URL = $baseURL . '?' . $encodedQuery;
  $transient_key = 'api_cache_' . md5($URL);
  $response = NULL;
  $cached_response = get_transient($transient_key);
  if ($cached_response !== FALSE) {
    $response = $cached_response;
  }
  else {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $URL);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);

    $responseCurl = curl_exec($ch);

    if ($responseCurl !== FALSE && !empty($responseCurl)) {
      set_transient($transient_key, $responseCurl, DAY_IN_SECONDS);
    }
    $response = $responseCurl;
  }

  $jsonResponse = json_decode($response);
  $data = ['message' => $jsonResponse];
  return new WP_REST_Response($data, 200);
}

/**
 *
 */
function informea_legislation_shortcode() {
  ob_start();
  ?>
    <div class="informea-container">
      <div class="facets-container"></div>
      <div class="legislation-list">
        <div class="search-container hidden">
          <form>
            <label for="searchtext">Search</label>
            <input placeholder="Type text to search in these results ..." name="searchtext"/>
            <button>Search</button>
          </form>
        </div>
        <div class="disclaimer hidden">
          <img src="<?php echo plugin_dir_url(__FILE__) . 'assets/faolex-logo.png'; ?>" alt="faolex logo"/>
          This content is exclusively provided by 
          <a href="https://www.fao.org/" target="_blank">FAO</a>
           / 
           <a href="https://www.fao.org/faolex/en" target="_blank">FAOLEX</a>
           /
           <a href="https://www.ecolex.org" target="_blank">ECOLEX</a> 
          <img src="<?php echo plugin_dir_url(__FILE__) . 'assets/ecolex-logo.png'; ?>" alt="ecolex logo"/>
        </div>
        <div class="top-info"></div>
        <div class="legislations"></div>
        <div class="pagination"></div>
        <div class="error"></div>
      </div>
    </div>
    <div class="loading-container">
      <div class="loading"></div>
    </div>
    <link href="<?php echo plugin_dir_url(__FILE__) . 'assets/nouislider.min.css'; ?>" rel="stylesheet" />
    <script src="<?php echo plugin_dir_url(__FILE__) . 'assets/nouislider.min.js'; ?>"></script>
    <script src="<?php echo plugin_dir_url(__FILE__) . 'assets/script.js'; ?>"></script>
    <link rel="stylesheet" href="<?php echo plugin_dir_url(__FILE__) . 'assets/style.css'; ?>">
  <?php
  return ob_get_clean();
}

add_shortcode('informea_legislation', 'informea_legislation_shortcode');
